#version 330

#if _VTF_TRANSFORM
uniform sampler1D transformMap;
#else
uniform mat4 world;
#endif
uniform mat4 view;
uniform mat4 proj;

in vec4 vertex;
in vec4 uv0; //uv, offset
in vec2 uv1; //transform idx, texture idx
in vec4 colour; //color

out vec4 vcolor;
out vec3 uv;

void main()
{
#if _VTF_TRANSFORM
	int fetchBase = int(3*uv1.x + 0.5);
	mat3x4 worldT;
	worldT[0] = texelFetch(transformMap, fetchBase, 0);
	worldT[1] = texelFetch(transformMap, fetchBase + 1, 0);
	worldT[2] = texelFetch(transformMap, fetchBase + 2, 0);
	vec4 worldPos = vec4(vertex * worldT, 1);
#else
	vec4 worldPos = world * vertex;
#endif
	vcolor = colour;
	uv = vec3(uv0.xy, uv1.y);
	vec4 viewPos = view * worldPos;
	gl_Position = proj * (viewPos + vec4(uv0.zw, 0.0, 0.0));
}
